/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.betterquesting;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.betterquesting.FactoryTaskRequirement;
import codersafterdark.compatskills.common.compats.betterquesting.gui.GuiTaskRequirementEditor;
import codersafterdark.compatskills.common.compats.betterquesting.gui.PanelTaskRequirement;
import codersafterdark.reskillable.api.ReskillableAPI;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.requirement.Requirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskRequirement
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    private List<String> requirements = new ArrayList<String>();
    private RequirementHolder holder;
    private boolean hasUncacheable;

    public String getUnlocalisedName() {
        return "compatskills.misc.betterquesting.requirement_task";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskRequirement.INSTANCE.getRegistryName();
    }

    public void detect(ParticipantInfo participant, DBEntry<IQuest> quest) {
        if (this.isComplete(participant.UUID)) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)participant.PLAYER);
        if (data == null) {
            return;
        }
        this.setHolder();
        if (data.matchStats(this.holder)) {
            this.setComplete(participant.UUID);
        }
        participant.markDirty(Collections.singletonList(quest.getID()));
    }

    private void setHolder() {
        if (this.holder == null) {
            ArrayList<Requirement> reqs = new ArrayList<Requirement>();
            for (String req : this.requirements) {
                Requirement requirement = ReskillableAPI.getInstance().getRequirementRegistry().getRequirement(req);
                if (requirement == null) continue;
                if (!requirement.isCacheable()) {
                    this.hasUncacheable = true;
                }
                reqs.add(requirement);
            }
            this.holder = new RequirementHolder(reqs);
        }
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskRequirement(rect, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiTaskRequirementEditor(parent, quest, this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        NBTTagList reqs = new NBTTagList();
        for (String req : this.requirements) {
            reqs.func_74742_a((NBTBase)new NBTTagString(req));
        }
        json.func_74782_a("requirements", (NBTBase)reqs);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.requirements.clear();
        NBTTagList reqs = json.func_150295_c("requirements", 8);
        for (NBTBase req : reqs) {
            if (!(req instanceof NBTTagString)) continue;
            this.requirements.add(((NBTTagString)req).func_150285_a_());
        }
        this.resetHolder();
    }

    private void resetHolder() {
        this.holder = null;
        this.hasUncacheable = false;
        this.setHolder();
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.stream().filter(completeUser -> users == null || users.contains(completeUser)).map(completeUser -> new NBTTagString(completeUser.toString())).forEach(arg_0 -> ((NBTTagList)jArray).func_74742_a(arg_0));
        json.func_74782_a("completeUsers", (NBTBase)jArray);
        return json;
    }

    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = json.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                CompatSkills.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    public RequirementHolder getRequirementHolder() {
        this.setHolder();
        return this.holder;
    }

    public List<String> getRequirements() {
        return this.requirements;
    }

    public void updateRequirements(List<String> requirements) {
        this.requirements = requirements;
        this.resetHolder();
    }

    public boolean hasUncacheable() {
        return this.hasUncacheable;
    }
}

